#!/bin/sh
# logmgrinst.sh: logmanager installation script
#
#

PYTHON="python3"
PKGLIST=""
BASEDIR="/usr/local"
PROG="nuhedlogd"
PROGSTART="nuhedlogd.py"
PROGSTART_VENV="run_nuhedlogd.sh"
PYVER="py3"
LOGMGRD_DIR="$BASEDIR/$PROG"
LOGMGRD_VENV_DIR="$BASEDIR/$PROG/.venv"

MYHOST="$(hostname --fqdn)"
MGRACC=$(cat nuhed_install.conf | grep LOGD_ACCESS | sed -e 's/LOGD_ACCESS://')

LOGMGRD_USERS="logmgrusers.list"

#zlib
PYTHON_RHEL="python3.9"
PYTHON_UBUNTU="python3"
RPMS="python39"
DPKGS="python3 python3-openssl python3-venv python3-virtualenv"


check_packages () {
  OS=$1
  PKGS=$2

  for PKG in $PKGS
  do
    if [ "$OS" = "debian" ];then
       sudo dpkg -s $PKG > /dev/null 2>/dev/null
    elif [ "$OS" = "rhel" ];then
       sudo rpm -q $PKG > /dev/null 2>/dev/null
    else
       echo "Invalid OS version"
       exit 1
    fi

    if [ "$?" = "1" ];then
         PKGLIST="$PKGLIST $PKG"
    fi
  done

}


# Ansi color code variables
red="\e[0;91m"
expand_bg="\e[K"
red_bg="\e[0;101m${expand_bg}"
green_bg="\e[0;102m${expand_bg}"
green="\e[0;92m"
white="\e[0;97m"
bold="\e[1m"
uline="\e[4m"
reset="\e[0m"


SUID=$(id -u)
echo -n "Checking for sudo rights "
# check for sudo rights
if [ "$SUID" -ne "0" ];then
  echo  "${red}${bold}FAIL${reset}"
  echo
  echo  "${red}${bold}Installation requires sudo rights (sudo ./install.sh)${reset}"
  exit 1
else
  echo  "${green}${bold}OK${reset}"
fi
echo


# Installing required packages
if [ -f /etc/redhat-release ];then

    PYTHON=$PYTHON_RHEL
    OS="rhel"
    check_packages "$OS" "$RPMS"
    echo "Following packaged needs to be installed: $PKGLIST"
    OS="rhel"

elif [ -f /etc/debian_version ];then
    PYTHON=$PYTHON_UBUNTU
    OS="debian"
    check_packages "$OS" "$DPKGS"
    echo "Following packaged needs to be installed: $PKGLIST"

else
   echo "Unkown OS version"
   exit 1
fi
echo

if [ ! -z "$PKGLIST" ];then
  echo -n "Install packages [Y/n] ? "
  read var

  if [ "$var" = "y" ] || [ "$var" = "y" ] || [ "$var" = "" ];then
    if [ "$OS" = "rhel" ];then
      sudo yum install -y $PKGLIST
    else
      sudo apt -qq install -y $PKGLIST
    fi
  fi
fi


# Create logmanagerdir && python venv
if [ ! -d "$LOGMGRD_VENV_DIR" ];then
  echo "Setup python virtual environment"
  mkdir  -p "$LOGMGRD_VENV_DIR"
  $PYTHON -m venv $LOGMGRD_VENV_DIR --system-site-packages
fi

$PYTHON -m venv $LOGMGRD_VENV_DIR --system-site-packages
. $LOGMGRD_VENV_DIR/bin/activate
python -m pip install --upgrade pip
python -m pip install cryptography
python -m pip install pyOpenSSL

echo "#!/bin/bash" > "$LOGMGRD_DIR/${PROGSTART_VENV}"
echo "source ${LOGMGRD_VENV_DIR}/bin/activate" >> "$LOGMGRD_DIR/${PROGSTART_VENV}"
echo "${LOGMGRD_VENV_DIR}/bin/python" ${LOGMGRD_DIR}/${PROGSTART}>> "$LOGMGRD_DIR/${PROGSTART_VENV}"
echo "exit 0" >> "$LOGMGRD_DIR/${PROGSTART_VENV}"
chmod 755 "$LOGMGRD_DIR/${PROGSTART_VENV}"

echo
# Check for wget
echo -n "Checking if wget exists "
if [ -f /usr/bin/wget ] || [ -f /usr/local/bin/wget ];then
  echo  "${green}${bold}OK${reset}"
else
  echo  "${red}${bold}FAIL${reset}"
fi
echo 


# Download version information
wget -q http://www.nuhedman.com/download/versions -O ./versions_ 2>/dev/null 1>/dev/null
if [ "$?"!="0" ];then
    echo "Warning: Unable to to download latest versions file, using default"
    echo 
else
    mv ./versions_ versions
fi 
LOGMGR_VER=$(cat versions | grep ${PROG}: | cut -d: -f2)

# Download source code
if [ ! -f ./${PROG}-${PYVER}-${LOGMGR_VER}.tar.gz ];then
  echo -n "Downloading ${PROG}-${PYVER}-${LOGMGR_VER} source code files "
  wget -q http://www.nuhedman.com/download/${PROG}-${PYVER}-${LOGMGR_VER}.tar.gz -O ./${PROG}-${PYVER}-${LOGMGR_VER}.tar.gz_ 2>/dev/null 1>/dev/null

  if [ "$?" = "0" ];then
     mv ./${PROG}-${PYVER}-${LOGMGR_VER}.tar.gz_ ./${PROG}-${PYVER}-${LOGMGR_VER}.tar.gz
     echo  "${green}${bold}OK${reset}"
  else
     if [ -f ./${PROG}-${PYVER}-${LOGMGR_VER}.tar.gz_ ];then
        rm ./${PROG}-${PYVER}-${LOGMGR_VER}.tar.gz_
     fi
     echo  "${red}${bold}FAIL${reset}"  
     echo "Failed to download http://www.nuhedman.com/download/${PROG}-${PYVER}-${LOGMGR_VER}.tar.gz"
     echo 
     exit 1
  fi
fi

if [ ! -f ./${PROG}-${PYVER}-${LOGMGR_VER}.tar.gz ];then
  echo " Error: Unable to find ${PROG}-${PYVER}-${LOGMGR_VER} source code files "
  echo " Manually download from: http://www.nuhedman.com/download/${PROG}-${PYVER}-${LOGMGR_VER}.tar.gz  "
  exit 1
fi


echo 
echo -n "Checking if ${PROG}-${PYVER}-${LOGMGR_VER} exists "
if [ -f ./${PROG}-${PYVER}-${LOGMGR_VER}.tar.gz ];then
  echo  "${green}${bold}OK${reset}"
else
  echo  "${red}${bold}FAIL${reset}"
  exit 1
fi
echo 


# stop running logmanager process
echo -n "Stopping running logmanager instance "

WAITSEC=0
while true;
do
  NUPID=""
  if [ -f /var/run/nuhedlogd.pid ];then
     NUPID=$(cat /var/run/nuhedlogd.pid)
  fi

  if [ -n "$NUPID" ];then
     kill $NUPID 2>/dev/null 1>/dev/null
  else
    break
  fi

  if [ $WAITSEC -ge 15 ];then
    break
  fi

  sleep 1
  WAITSEC=$(($WAITSEC + 1))
 echo -n ". "
done
if [ -z "$NUPID" ];then
  echo  "${green}${bold}OK${reset}"
  echo
else

  echo  "${red}${bold}FAIL${reset}"
  echo 
  echo "Failed stop running ${PROG} process PID $NUPID, stop manually."
  exit 1
fi


# unpack installation package
echo -n "Installing source files into $LOGMGRD_DIR "
gzip -dc ${PROG}-${PYVER}-${LOGMGR_VER}.tar.gz | tar -C $BASEDIR -xvf -  > /dev/null 2>/dev/null
if [ -d $LOGMGRD_DIR ];then
  echo  "${green}${bold}OK${reset}"
else
  echo  "${red}${bold}FAIL${reset}"
  exit 1
fi

echo 
cd $LOGMGRD_DIR

# Create certificates
if [ ! -f $LOGMGRD_DIR/sserver.key ];then
  openssl req -x509 -newkey rsa:2048 -keyout $LOGMGRD_DIR/sserver.key -out $LOGMGRD_DIR/sserver.crt -nodes -days 3600 -subj "/C=FI/ST=NMGR/L=N/O=IT/OU=nuhed/CN=$MYHOST/emailAddress=root@$MYHOST"

  openssl req -x509 -newkey rsa:2048 -keyout $LOGMGRD_DIR/cserver.key -out $LOGMGRD_DIR/cserver.crt -nodes -days 3600 -subj "/C=FI/ST=NMGR/L=N/O=IT/OU=nuhed/CN=$MYHOST/emailAddress=root@$MYHOST"

fi

echo -n "Setup admin user ... "
echo "${MGRACC}" > $LOGMGRD_DIR/$LOGMGRD_USERS
chmod 755 $LOGMGRD_DIR/$LOGMGRD_USERS
if [ "$?"="0" ];then
  echo  "${green}${bold}OK${reset}"
else
  echo  "${red}${bold}FAIL${reset}"
  exit 1
fi

echo 

echo -n "Starting ${PROG} service $LOGMGRD_DIR/${PROGSTART_VENV} ... "
sudo "$LOGMGRD_DIR/${PROGSTART_VENV}"
if [ "$?" -eq "0" ];then
  echo  "${green}${bold}OK${reset}"
else
  echo   "${red}${bold}FAIL${reset}"
  echo 
  echo  "${red}${bold}Make install failed, see install.log for more details.${reset}"
  exit 1
fi
echo 

cd - 2>/dev/null 1>/dev/null

if [ -d /etc/systemd/system ];then
  sudo cp -f nuhedlogd.service /etc/systemd/system/nuhedlogd.service
  sudo chmod 664 /etc/systemd/system/nuhedlogd.service
  sudo systemctl daemon-reload
  sudo systemctl enable nuhedlogd 2>/dev/null
fi

exit 0
