#!/usr/bin/env python

# nmgr-userdel.py
#
# Copyright (C) 2007 Tuomo Makinen (tjam@users.sourceforge.net)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

import os
import sys
import string
import fcntl

# nuhemgr conf directory
try:
    Conf_dir = os.environ["LOGMGRDIR"]
except KeyError:
    Conf_dir = os.getcwd()

Ulist_file = os.path.join(Conf_dir, "logmgrusers.list")

def main():
    try:
        uname = sys.argv[1]
    except:
        sys.stderr.write("usage: nmgr-userdel name\n")
        sys.exit()
    else:
        remove_user(uname)
    sys.exit()
    
def remove_user(uname):
    try:
        fp = open(Ulist_file)
    except IOError, e:
        sys.stderr.write("Can't modify nmgrusers.list: " + e[1] + "\n")
        sys.exit(1)
    else:
        fcntl.flock(fp.fileno(), fcntl.LOCK_SH)
        userlist = fp.readlines()
        fcntl.flock(fp.fileno(), fcntl.LOCK_UN)
        fp.close()
        uindex = {}
        for j in xrange(len(userlist)):
            luname = string.split(userlist[j], ":")
            uindex[luname[0]] = j
        if uname in uindex:
            userlist.pop(uindex[uname])
            rewrite_list(userlist)
            sys.stdout.write("\nUser " + uname + " succesfully deleted.\n")
        else:
            sys.stderr.write("Can't find user: " + uname + "\n")
            sys.exit(1)
            
def rewrite_list(userlist):
    try:
        fp = open(Ulist_file, 'w')
    except IOError, e:
        sys.stderr.write("Can't write to nmgrusers.list: " + e[1] + "\n")
        sys.exit(1)
    else:
        fcntl.flock(fp.fileno(), fcntl.LOCK_EX)
        for i in xrange(len(userlist)):
            fp.write(userlist[i])
        fcntl.flock(fp.fileno(), fcntl.LOCK_UN)
        fp.close()
            
os.umask(0066)
main()
