#!/bin/bash
#
# entry_web.sh
#
# description: entrypoint for web container
#
#

APP_PATH="/opt/nuhedman"
CONFIG_PATH="$APP_PATH/lib/class/plugins/config"
MGRBIN_PATH="$APP_PATH/lib/class/plugins/bmm_nuhe_manager/bin"
LOGDBIN_PATH="$APP_PATH/lib/class/plugins/bmm_log_manager/bin"

chown -R www-data $APP_PATH

# update container ip for dynamic ip
cat /etc/hosts | grep -v nuhedcontainer > /tmp/hosts
cat $APP_PATH/container_host.txt >> /tmp/hosts
cat /tmp/hosts > /etc/hosts

if [ ! -f $APP_PATH/initdone ];then
   rm -f /var/log/apache2/error.log
   touch /var/log/apache2/error.log
   chown www-data:www-data /var/log/apache2/error.log

fi
 
if [ ! -d  $CONFIG_PATH/bmm_nuhe_manager/tmp ];then
     mkdir $CONFIG_PATH/bmm_nuhe_manager/tmp
fi
 
chown -R www-data /opt/home
source /etc/apache2/envvars
service apache2 start
/usr/sbin/cron

LASTPOLL=0
while [ 1 -eq 1 ]
do 
  if [ -f $APP_PATH/conf/config.conf ];then

    if [ ! -f $APP_PATH/initdone ];then
       $MGRBIN_PATH/bmm_nuhe_manager.py init
       $LOGDBIN_PATH/bmm_log_manager.py node_sync
       touch $APP_PATH/initdone
    fi

    if [ -f /poll.log ];then
       LASTPOLL=$(cat /poll.log | cut -d" " -f1)
    fi

    # poll every 30 seconds
      echo "$(date +%s) $(date) [WEB] Epoch: $(date +%s) POLL: $LASTPOLL " >> /tmp/poll.log
    if [ $(( $(date +%s) - 30 )) -gt $LASTPOLL ];then
      cd $MGRBIN_PATH
      $MGRBIN_PATH/bmm_nuhe_manager.py poll
      #$MGRBIN_PATH/bmm_nuhe_manager.py blocked
      echo "$(date +%s) $(date) [WEB] EXEC Epoch: $(date +%s) POLL: $LASTPOLL " >> /tmp/poll.log
      echo "$(date +%s) $(date) [WEB] Entry loop executed" > /poll.log
    fi

    cd $LOGDBIN_PATH
    $LOGDBIN_PATH/bmm_log_manager.py node_sync
    $LOGDBIN_PATH/bmm_log_manager.py conf_sync
    $LOGDBIN_PATH/bmm_log_manager.py log_sync
    $LOGDBIN_PATH/bmm_log_manager.py log_upload

    # handle jobs (crontab)
    if [ -f $CONFIG_PATH/bmm_nuhe_manager/tmp/nuhedman.cron ];then
       cp -f $CONFIG_PATH/bmm_nuhe_manager/tmp/nuhedman.cron /etc/cron.d/nuhedman
       rm -f $CONFIG_PATH/bmm_nuhe_manager/tmp/nuhedman.cron 
    fi
  fi
done

echo " !!!!! Entrpoint for web exited !!!!!"
exit 0
