#!/bin/bash

MGRPYDIR="/usr/local/nuhemgr/server"
MGRPY="nuhemgrd.py"
MGRPID=$(ps -elf | grep nuhemgr | grep -v grep | awk '{print $4}')

STARTUP="f"
PIDFILE="/var/run/nuhemgrd.pid"
SLEEPTIMER=3

cd $MGRPYDIR

if [  -n "$MGRPID" ];then
  kill $MGRPID
fi

while [ 1 == 1 ]
do
  MGRPID=$(ps -elf | grep nuhemgr | grep -v grep | awk '{print $4}')
  if [ $SLEEPTIMER -ge 3 ];then
    break
  fi

  if [ -z "$MGRPID" ];then
    python ./nuhemgrd.py 
    STARTUP="t"
    break
  fi
  SLEEPTIMER=$(($SLEEPTIMER+1))
  sleep 1
done

if [ "$STARTUP" == "f" ];then
  if [ -n "$MGRPID" ];then
    kill -9 $MGRPID
  fi

  if [ -f $PIDFILE ];then
    rm -f $PIDFILE
  fi
  python $MGRPYDIR/$MGRPY
fi

exit 0
