#!/bin/bash
#
# Nuhedman installer
#

NUHEDWEB_DIR="nuhedman"
NUHEDWEB_CONF_DIR="$NUHEDWEB_DIR/conf"
NUHEDWEB_PLUGIN_DIR="$NUHEDWEB_DIR/lib/class/plugins"
NUHEDWEB_ATTACHMENT_DIR="$NUHEDWEB_DIR/attachments"

PLUGIN_WEB_HOME="home/pluginconfig"
CONFIG_WEB_HOME="home/webconfig"
ATTACHMENT_WEB_HOME="home/attachments"

OS_RHEL=""
DOCKER_COMPOSE="docker-compose"

STARTUP_CONF="conf/startup.cnf"

if [ -f /etc/debian_version ];then
  if [ -n "$(cat /etc/debian_version | grep trixie)" ];then
    DOCKER_COMPOSE="docker-compose-v2"
  else
     if [ -n "$(cat /etc/debian_version | grep bookworm)" ];then
       DOCKER_COMPOSE="docker-compose-v2"
     fi	
   fi  
fi

echo -n "Verifying docker installation"
# is docker installed ?
DOCKCHECK="$(whereis docker | awk '{ print $2 }')"
if [ -z "$DOCKCHECK" ];then
    if [ -z "$OS_RHEL" ];then
	echo "...not found. Install repository package docker.io ${DOCKER_COMPOSE} docker-buildx."
    else
	echo 
	echo "Docker installation not found. See instuctions below"
	cat ./INSTALL_CONTAINER_RHEL
    fi
    exit 1
 else
   echo "...docker installed"
fi
echo

if [ -n "$(docker --help | grep -i compose)" ];then
  DOCKER_COMPOSE_EXEC="docker compose"
else
  DOCKER_COMPOSE_EXEC="docker-compose"
fi

if [ -f /etc/redhat-release ];then
  OS_RHEL="true"
  DOCKER_COMPOSE="docker compose"
fi

echo -n "Verifying docker-compose installation"
# is docker installed ?
DOCKCHECK="$(whereis docker-compose | awk '{ print $2 }')"
if [ ! -f /usr/libexec/docker/cli-plugins/docker-compose ];then
 if [ -z "$DOCKCHECK" ];then
	echo "...not found. Install repository package ${DOCKER_COMPOSE} docker-buildx."
   exit 1
 fi
fi
echo "...docker-compose installed"
echo

echo -n "Verifying docker buildx installation"
if [ ! -f /usr/libexec/docker/cli-plugins/docker-buildx ];then
 if [ ! -d "/usr/share/doc/docker-buildx" ];then
        echo "...not found. Install repository package docker-buildx."
   exit 1
 fi
fi
echo "...docker-buildx installed"
echo


# install nuhed and nuhedmanweb
./updater.sh

# update versions vile
cp -f versions nuhedman/versions	


if [ ! -d $PLUGIN_WEB_HOME/bmm_nuhe_manager ] || [ ! -d $NUHEDWEB_PLUGIN_DIR/config ];then
  cd $NUHEDWEB_PLUGIN_DIR > /dev/null 2>/dev/null
  sudo ln -fs ../../../../$PLUGIN_WEB_HOME config
  cd - >/dev/null 2>/dev/null

  sudo mkdir -p $PLUGIN_WEB_HOME > /dev/null 2>/dev/null
  if [ -d $NUHEDWEB_PLUGIN_DIR/config.init  ] && [ "$(ls $NUHEDWEB_PLUGIN_DIR/config.init/ | wc -l )" != "0" ];then
    sudo cp -rf $NUHEDWEB_PLUGIN_DIR/config.init/* $PLUGIN_WEB_HOME
  fi

  if [ ! -d $PLUGIN_WEB_HOME/bmm_nuhe_manager ];then
    sudo mkdir -p $PLUGIN_WEB_HOME/bmm_nuhe_manager > /dev/null 2>/dev/null
  fi
fi

if [ ! -f $CONFIG_WEB_HOME/config.conf_ ];then
  
  if [ ! -d $CONFIG_WEB_HOME ];then
     sudo mkdir -p $CONFIG_WEB_HOME > /dev/null 2>/dev/null
  fi

  cd $NUHEDWEB_DIR > /dev/null 2>/dev/null
  sudo cp -rf  conf.init/* ../$CONFIG_WEB_HOME
  cd - >/dev/null 2>/dev/null
fi

if [ ! -d $NUHEDWEB_CONF_DIR ];then
  cd $NUHEDWEB_DIR
  sudo ln -s ../$CONFIG_WEB_HOME conf
  cd - >/dev/null 2>/dev/null
fi


if [ ! -d $ATTACHMENT_WEB_HOME ];then
  if [ -d $NUHEDWEB_ATTACHMENT_DIR ];then
    rmdir $NUHEDWEB_ATTACHMENT_DIR
  fi

  sudo mkdir -p $ATTACHMENT_WEB_HOME > /dev/null 2>/dev/null
  cd $ATTACHMENT_CONF_DIR > /dev/null 2>/dev/null
  if [ ! -L attachments ];then
     sudo ln -s ../$ATTACHMENT_WEB_HOME attachments
  fi
  cd - >/dev/null 2>/dev/null
fi

MYHOST=$(hostname)
mypass=$(date +%s | sha256sum | base64 | head -c 16;echo)

cat conf/public_nuhe_manager.json.tpl | sed -e 's/<manager>/nuhemgr/' | sed -e 's/<user>/nuhemgr/'  | sed -e "s/<passwd>/$mypass/" | sed -e "s/<common_name>/$MYHOST/" > home/pluginconfig/bmm_nuhe_manager/public_nuhe_manager.json

cat conf/admin-adduser.py.tpl | sed -e "s/<passwd>/$mypass/" > conf/admin-adduser.py

sudo cp -f conf/nuhed.logrotate nuhedman/lib/class/plugins/bmm_nuhe_manager/files/nuhed.logroate
sudo cp -f $STARTUP_CONF $CONFIG_WEB_HOME

sudo chmod 777 -R $CONFIG_WEB_HOME
sudo chmod 777 -R $PLUGIN_WEB_HOME
sudo chmod 777 -R $ATTACHMENT_WEB_HOME

CONTAINER_HOST=$(hostname --fqdn)
CONTAINER_IP=$(hostname -I | awk '{print $1}')
echo "${CONTAINER_IP} ${CONTAINER_HOST}"  > ./nuhedman/container_host.txt
sudo cp -f bin/caupdate.sh nuhed/nuhemgr/server/caupdate.sh
sudo cp -f bin/restartmgr.sh nuhed/nuhemgr/server/restartmgr.sh

if [ -n "$(service docker status | grep running 2>/dev/null)" ];then
  sudo cat docker/docker-compose.tmpl  | sed -e "s/<hostname>/$MYHOST/g" > docker-compose.yml
  sudo DOCKER_BUILDKIT=1 $DOCKER_COMPOSE_EXEC build --no-cache
else
   echo
   echo "Docker daemon not running, run 'sudo service docker start'"
   exit 1
fi
touch init.done
echo 
echo 
echo "Execute sudo ./run.sh to start the container."
echo "After startup open url http://<your_host_name> to finalize configuration"
exit 0
