#!/bin/bash
#
# Upodate certificate
#
#
MGRDIR="/usr/local/nuhemgr/server"
PEMFILE="/usr/local/nuhemgr/server/CAnuhemgr.pem"
CRTDIR="/usr/local/nuhemgr/server/ca"
CRTBAKDIR="$CRTDIR/bak"
MGRPID=$(ps -elf | grep nuhemgr | grep -v grep | awk '{print $4}')

if [ ! -d "$CRTBAKDIR" ];then
  mkdir -p $CRTBAKDIR
fi

find $CRTDIR -maxdepth 1 -type f | while read CRT_FULL_PATH
do 

  UPDATE_CRT="f"
  CRTF=$(basename $CRT_FULL_PATH)
  if [ -f $CRTBAKDIR/$CRTF ];then 
    diff $CRT_FULL_PATH $CRTBAKDIR/$CRTF > /dev/null
    if [ "$?" -ne "0" ];then
      UPDATE_CRT="t"
    fi
  else
      UPDATE_CRT="t"
  fi 

  if [ "$UPDATE_CRT" == "t" ];then
    cat $CRT_FULL_PATH >> $PEMFILE
    mv -f $CRT_FULL_PATH $CRTBAKDIR
    $MGRDIR/restartmgr.sh
  fi

done

exit 0


