#!/usr/bin/python3

# [Sun Jan 15 12:38:48.138424 2023] [php7:notice] [pid 671] [client 172.18.0.1:39598] [LOGGER][dbController][DEBUG] dbController::getDbInstance | LOGINACT:  LOGGEDIN: 1 LOGOUT:   ISESS: 3849819056 GLOB: 8, referer: http://localhost/?page=manage&handler=project&action=retriev
import base64
import os
import json
import re
import sys
from datetime import datetime
import time


#
# dict hash=>date->hour
#

def get_config():

  with open ("logconfig.json") as myconf_file:
     myconfig = json.load(myconf_file) 

  return myconfig

def init_dict_log_keys(mydict,myb64file,dict_key_date,dict_key_hour,log_key):
  # date as a key
  if not dict_key_date in mydict[myb64file].keys():
    mydict[myb64file][dict_key_date] = {}

   # date as a key
  if not dict_key_hour in mydict[myb64file][dict_key_date].keys():
    mydict[myb64file][dict_key_date][dict_key_hour] = {}

  if not log_key in mydict[myb64file][dict_key_date][dict_key_hour].keys():
    mydict[myb64file][dict_key_date][dict_key_hour][log_key] = []

  return mydict

def main():
  config = get_config()

  hostname    = os.uname()[1]
  datadir     = "./data"
  logdir      = "./log"
  partd       = []
  delimeter_s = "["
  delimeter_e = "]"
  cols        = 7
  mydict      ={}

  dformat = "%a %b %d %H:%M:%S.%f %Y"
  files   = config["files"]
  myregex  = "\[(.+?)\]\s*\[(.+?)\]\s*\[(.+?)\]\s*\[(.+?)\]\s*\[(.+?)\]\s*\[(.+?)\]\s*\[(.+?)\]\s*(.+)"
  r       = re.compile(myregex)

  # dbController::getCidSchemaDataLOG:
  myregex_logkey = "(\S+::\S+)\s+(.+)"
  rk             = re.compile(myregex_logkey)
  
  for i in range(len(files)):
    myb64file  = base64.b64encode(bytes(files[i],'utf-8')).decode('ascii')
    mydict[myb64file] = {}
    handle = open(files[i])
    print ("Opening:"+files[i])
    line = handle.readline()
    while line:
      try:
        print("TELL:"+str(handle.tell()))
        ml      = r.match(line)
        mymsg   = ml.group(8)
        partd   = [ml.group(1),ml.group(2),ml.group(3),ml.group(4),ml.group(5),ml.group(6),ml.group(7)]

        # Sat Jan 07 09:12:23.493370 2023
        mytime  = datetime.strptime(ml.group(1),dformat)
        myepoch = (time.mktime(mytime.timetuple()))
        #print ("MYTIME:"+str(mytime)+" EPOCH: "+str(myepoch)+"\n")

        dict_key_date     = str(mytime.year)+"-"+str(mytime.month)+"-"+str(mytime.day)
        dict_key_datetime = dict_key_date+" "+str(mytime.hour)+":"+str(mytime.minute)+"."+str(mytime.second)
        dict_key_hour     = str(mytime.hour)

        # get key from log message
        mk       = rk.match(mymsg)
        log_key  = mk.group(1)

        #print ("KEY:"+str(log_key));
        mydict = init_dict_log_keys(mydict,myb64file,dict_key_date,dict_key_hour,log_key)
      
        mydict[myb64file][dict_key_date][dict_key_hour][log_key].append([{'epoch':str(myepoch),'datetime':dict_key_datetime,"msg":mymsg,"parts":partd}])
      
      except Exception as e:
        a = 1
        #print ("Error:"+str(e))
        #print (line)
      finally:
        line = handle.readline()

    mydict['hostname'] = hostname
    myfile = os.path.basename(files[i]) + ".json"
    fp = open (datadir + "/" + myfile,"w") 
    myjson = json.dumps(mydict)
    fp.write(myjson)
    fp.close()


main()


