#!/usr/bin/python3

# nmgr-adduser.py
#
# Copyright (C) 2007 Tuomo Makinen (tjam@users.sourceforge.net)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

import os
import sys
import hashlib
import base64
import string
import getpass
import fcntl

# nuhemgrd conf directory
try:
    Conf_dir = os.environ["LOGMGRDIR"]
except KeyError:
    Conf_dir = os.getcwd()

Ulist_file = os.path.join(Conf_dir, "logmgrusers.list")

def main():
    try:
        if sys.argv[1]:
            uname = sys.argv[1]
    except IndexError:
        uname = get_name()
    check_user(uname)
    upassw = get_passwd()
    rwacc = add_nodes(uname)
    write_userinfo(uname, upassw, rwacc)

def get_name():
    while 1:
        try:
            uname = input("Username: ")
        except KeyboardInterrupt:
            sys.stderr.write("\n")
            sys.exit(1)
        if uname == "":
            sys.stderr.write("Username can't be empty.\n")
        else:
            return uname

def get_passwd():
    while 1:
        try:
            passwd = getpass.getpass()
            if passwd == "":
                sys.stderr.write("Password can't be empty.\n")
            else:
                passwd2 = getpass.getpass("Retype password: ")
                if passwd != passwd2:
                    sys.stderr.write("\nPasswords do not match.\n")
                else:
                    upassw = base64.b64encode(hashlib.md5(passwd.encode('utf-8')).digest()).decode('utf-8')
                    return upassw
        except KeyboardInterrupt:
            sys.stderr.write("\n")
            sys.exit(1)

def add_nodes(uname):
    sensor_l = []

    print ("\nYou can now add sensors and access rights (read/read write) for user.")
    print ("If you want user has rw access for all managed sensors press '.' now.")
    print ("When you are ready, just press '.'\n")

    while 1:
        sensor = input("Sensor: ")
        if sensor == "":
            sys.stderr.write("Sensor can't be empty.\n")
            continue
        elif sensor == ".":
            break
        else:
            while (1):
              rwacc = input("Rights (type 'r' or 'rw'): ")
              if rwacc == "r" or rwacc == "rw":
                  break
              else:
                  sys.stderr.write("You must specify r or rw.\n")
                  continue
        
            sensor_l.append([sensor, rwacc])
            print ("\nSensor " + sensor + " added with " + rwacc + " rights\n")

    if len(sensor_l) == 0:
        print ("User " + uname + " has rw access for all managed sensors")
        sensor_l.append(["all", "rw"])
        return sensor_l
 
    print ("User " + uname + " has access for following sensors:")
    for i in range(len(sensor_l)):
        print ("Sensor: " + sensor_l[i][0])
        print ("Rights: " + sensor_l[i][1])

    return sensor_l
 
def check_user(uname):
    try:
        fp = open(Ulist_file)
    except IOError:
        pass
    else:
        fcntl.flock(fp.fileno(), fcntl.LOCK_SH)
        userlist = fp.readlines()
        fcntl.flock(fp.fileno(), fcntl.LOCK_UN)
        fp.close()
        for i in range(len(userlist)):
            scolon = userlist[i].find(":")
            luname = userlist[i][:scolon]
            if uname == luname:
                sys.stderr.write("User " + uname + " already exists.\n")
                sys.exit(1)

def write_userinfo(uname, upassw, rwacc):
    estr = uname + ":"
    for i in range(len(rwacc)):
        estr += rwacc[i][0] + "," + rwacc[i][1] + ":"
    estr += upassw+"\r\n"

    try:
        fp = open(Ulist_file, "a")
    except IOError as e :
        sys.stderr.write("Can't write to " + Ulist_file + ": " + e[1] + "\n")
        sys.exit(1)
    else:
        fcntl.flock(fp.fileno(), fcntl.LOCK_EX)
        fp.write(estr)
        fcntl.flock(fp.fileno(), fcntl.LOCK_UN)
        fp.close()
    
os.umask(0o066)
main()
