#!/bin/bash
#
# entry_nmgr.sh
#
# description: entrypoint for nodemgr container
#
#

MGRDIR="/usr/local/nuhemgr/server"
MGRPORT="5403"
MYHOST=$(hostname)
PIDFILE="nuhemgrd.pid"

function start_mgrd {

  cd $MGRDIR
  MGRPID=$(ps -elf | grep nuhemgr | grep -v grep | awk '{print $4}')
  if [ -z "$MGRPID" ];then
    if [ -f /var/run/$PIDFILE ];then
      rm -f /var/run/$PIDFILE
    fi
    python ./nuhemgrd.py 
  fi

  if [ -f /opt/home/concheck ]; then
    if [ "$(cat /opt/home/concheck)" == "0" ];then
	 echo "$(date) Requesting restart: $(date +%s)" >> /tmp/pulla.txt
        ./restartmgr.sh
    fi
  fi
}

# Create certificates during first boot
if [ ! -f $MGRDIR/sserver.key ];then
  openssl req -x509 -newkey rsa:2048 -keyout $MGRDIR/sserver.key -out $MGRDIR/sserver.crt -nodes -days 3600 -subj "/C=FI/ST=NMGR/L=N/O=IT/OU=nuhed/CN=$MYHOST/emailAddress=root@$MYHOST"

  openssl req -x509 -newkey rsa:2048 -keyout $MGRDIR/cserver.key -out $MGRDIR/cserver.crt -nodes -days 3600 -subj "/C=FI/ST=NMGR/L=N/O=IT/OU=nuhed/CN=$MYHOST/emailAddress=root@$MYHOST"

fi 

cd $MGRDIR

python /admin-adduser.py


while [ 1 -eq 1 ]
do 
  start_mgrd
  $MGRDIR/caupdate.sh
  sleep 10
done

exit 0
