#!/bin/bash
RUN_PID=$( ps -elf | grep run_nuhedlogd | grep -v grep | awk '{print $4}')
PROGNAME_PID_FILE="/var/run/run_nuhedlogd.pid"
NUHEDLOGD_PID_FILE="/var/run/nuhedlogd.pid"
if [ -f ${PROGNAME_PID_FILE} ];then
   echo "$PROGNAME_PID_FILE found, program alreay running ?"
   exit 1
fi	

exit_prog (){
	echo "PULLA $PROGNAME_PID_FILE"
  rm -f $PROGNAME_PID_FILE
  exit 0
}

trap 'exit_prog' SIGKILL
trap 'exit_prog' SIGTERM
trap 'exit_prog' SIGINT

echo $RUN_PID > $PROGNAME_PID_FILE
MYHOST=$(hostname --fqdn)
source /usr/local/nuhedlogd/.venv/bin/activate
while [ 1 -eq 1 ];do
  NUHEDLOGD_PID=$( ps -elf | grep nuhedlogd.py | grep -v grep | awk '{print $4}')
  if [ -n "$NUHEDLOGD_PID" ];then
    if [ -f /usr/bin/wget ] || [ -f /usr/local/bin/wget ];then
      wget -q --spider --tries=1 --timeout=1 $MYHOST:5405
      if [ "$?" != "0" ];then
        kill -9 $NUHEDLOGD_PID
	sleep 1
        if [ -f ${NUHEDLOGD_PID_FILE} ];then
          rm -f ${NUHEDLOGD_PID_FILE}
	fi
        /usr/local/nuhedlogd/.venv/bin/python /usr/local/nuhedlogd/nuhedlogd.py
      fi
    fi
  else
    if [ -f ${NUHEDLOGD_PID} ];then
      rm -f ${NUHEDLOGD_PID}
    fi
    /usr/local/nuhedlogd/.venv/bin/python /usr/local/nuhedlogd/nuhedlogd.py
  fi
  sleep 30
done
rm -f ${PROGNAME_PID_FILE}
exit 0
