#!/bin/bash

MYDIR=$(pwd)
SCRT="${MYDIR}/nuhed/nuhemgr/server/sserver.crt"
TCRT="${MYDIR}/nuhedman/conf/sserver.crt"

OS_RHEL=""
if [ -n "$(docker --help | grep -i compose)" ];then
  DOCKER_COMPOSE_EXEC="docker compose"
else
  DOCKER_COMPOSE_EXEC="docker-compose"
fi

# Install server certificate if required
if [ ! -f "$TCRT" ];then
   cp -f $SCRT $TCRT
fi   

CONTAINER_HOST=$(hostname --fqdn)
CONTAINER_IP=$(hostname -I | awk '{print $1}')

echo "${CONTAINER_IP} ${CONTAINER_HOST}"  > ./nuhedman/container_host.txt

sudo $DOCKER_COMPOSE_EXEC  up


exit 0
