#!/bin/bash
#
# Update script for nuhedman
#
#

DEBUG="0"

function update_pkg () {

   PROG=$1
   VER_NEW_NUHED=$2


   PKG_NAME="${PROG}-${VER_NEW_NUHED}"

   # echo "PKG: $PKG_NAME"
   if [ -n "$PROG" ] && [ -n "$VER_NEW_NUHED" ];then
     if [ ! -f download/${PKG_NAME}.tar.gz ];then
       echo "  Downloading ${PKG_NAME}"
       wget -q -O download/${PKG_NAME}.tar.gz  http://www.nuhedman.com/download/${PKG_NAME}.tar.gz
     fi

     if [ -f  download/${PKG_NAME}.tar.gz ];then
       echo "  Installing ${PKG_NAME}"
       tar -xvzf download/${PKG_NAME}.tar.gz -C . > /dev/null
       if [ $? -ne 0 ];then
	  echo 
          echo "ERROR: Failed to untar download/${PKG_NAME}"
	  exit 1
       fi 
       if [ "$DEBUG" == "0" ];then
         cat versions | grep -v "${PROG}:" > versions_
         echo "${PROG}:${VER_NEW_NUHED}" >> versions_
          mv -f versions_ versions
       fi
       echo "  ${PROG} version ${VER_NEW_NUHED} installed"
     else
       echo "Error: File  download/${PKG_NAME}.tar.gz not found"
       exit 1
     fi
   else
      echo "PROGRAM / VERSION cannot be null"
      exit 1
   fi 
}


function updater () {

  PROG=$1
  VER_NUHED=$2
  VER_NEW_NUHED=$3

  if [ -z "$VER_NEW_NUHED" ];then
    echo "Error: Installed version cannot be empty"
    exit 1
  fi

  # Update nuhed
  echo -n "Version ${VER_NEW_NUHED} detected, update [Y/n] ? "
  read upd
  if [  "$upd" == "y" ] || [ "$upd" == "Y" ];then
       update_pkg $PROG $VER_NEW_NUHED
  fi

  echo 
}


if [ ! -d download ];then
  mkdir download
fi

if [ "$DEBUG" == "0" ];then
   wget -q -O download/versions http://www.nuhedman.com/download/versions
   if [ $? -ne 0 ];then
     echo "Unable to check for updates"
     cp -f versions download/versions
  fi
fi

VER_NUHEDMANWEB=$(echo -n "$(cat versions | grep nuhedmanweb | cut -d: -f2)")
VER_NUHED=$(echo -n "$(cat versions | grep nuhed | grep -v nuhedl | grep -v nuhedman | cut -d: -f2)")
VER_NUHEDMAN=$(echo -n "$(cat versions | grep nuhedman | grep -v nuhedmanweb | cut -d: -f2)")

VER_NEW_NUHEDMANWEB=$(echo -n "$(cat download/versions | grep nuhedmanweb | cut -d: -f2)")
VER_NEW_NUHED=$(echo -n "$(cat download/versions | grep -v nuhedman | grep -v nuhedl |  grep  nuhed |cut -d: -f2)")
VER_NEW_NUHEDMAN=$(echo -n "$(cat download/versions | grep nuhedmanweb | grep nuhedman | cut -d: -f2)")

#echo "VOWEB: $VER_NUHEDMANWEB WOMAN: $VER_NUHEDMAN VONUHED: $VER_NUHED"
#echo "VNWEB: $VER_NEW_NUHEDMANWEB WNMAN: $VER_NEW_NUHEDMAN VNNUHED: $VER_NEW_NUHED"
# update nuhed
if [ -d nuhed ];then
  if [ "$VER_NUHED" != "$VER_NEW_NUHED" ];then
    # update nuhed
    echo "Updating nuhed"
    updater "nuhed" "$VER_NUHED" "$VER_NEW_NUHED" ""
  fi
else
  update_pkg "nuhed" "$VER_NEW_NUHED" ""
fi

if [ -d nuhedman ];then
  # update nuhedmanager (web)
  if [ "$VER_NUHEDMANWEB" != "$VER_NEW_NUHEDMANWEB" ];then
     echo "Updating nuhedman Web"
     updater "nuhedmanweb" "$VER_NUHEDMANWEB" "$VER_NEW_NUHEDMANWEB" ""
  fi
else
  update_pkg "nuhedmanweb" "$VER_NEW_NUHEDMANWEB" ""
fi


exit 0
